# CMS Setup Guide - SAAM Cabins Website

## Overview
Your SAAM Cabins website is now CMS-enabled using Contentful, a powerful headless CMS that allows you to manage content and images without touching code. This guide will walk you through setting up and using the CMS system.

## Benefits of CMS Integration
- ✅ **No Code Changes**: Update content, images, and products through a web interface
- ✅ **Rich Media Management**: Upload and optimize images automatically
- ✅ **SEO Control**: Manage meta descriptions, titles, and content for better search rankings
- ✅ **Multi-user Access**: Allow team members to manage different content areas
- ✅ **Content Scheduling**: Schedule content updates and publish/unpublish items
- ✅ **Version History**: Track changes and revert if needed

## Setup Instructions

### Step 1: Create Contentful Account
1. Go to [contentful.com](https://www.contentful.com) and sign up for a free account
2. Create a new space (call it "SAAM Cabins")
3. Note down your Space ID from the space settings

### Step 2: Get API Keys
1. In your Contentful space, go to **Settings > API Keys**
2. Click **Add API Key** to create a new key
3. Copy the **Space ID** and **Content Delivery API - access token**

### Step 3: Configure Environment Variables
1. Create a `.env.local` file in your project root (copy from `.env.local.example`)
2. Add your Contentful credentials:
```env
CONTENTFUL_SPACE_ID=your_space_id_here
CONTENTFUL_ACCESS_TOKEN=your_access_token_here
```

### Step 4: Create Content Models
In Contentful, create these content types:

#### 4.1 Company Info (Content Type ID: `companyInfo`)
- **Company Name** (Text)
- **Tagline** (Text) 
- **Description** (Long text)
- **Phone Number** (Text)
- **WhatsApp Number** (Text)
- **Email** (Text)
- **Address** (Long text)
- **Working Hours** (Text)
- **Logo** (Media - single file)
- **Hero Image** (Media - single file)

#### 4.2 Product (Content Type ID: `product`)
- **Name** (Text) - Required
- **Slug** (Text) - Required, unique
- **Category** (Text)
- **Short Description** (Text)
- **Full Description** (Rich text)
- **Features** (Text - multiple values)
- **Specifications** (JSON object)
- **Applications** (Text - multiple values)
- **Images** (Media - multiple files)
- **Price** (Number - decimal)
- **Is Active** (Boolean)
- **Order** (Number - integer)

#### 4.3 Feature (Content Type ID: `feature`)
- **Title** (Text) - Required
- **Description** (Text)
- **Icon** (Text) - Icon name from Lucide React
- **Order** (Number - integer)
- **Is Active** (Boolean)

#### 4.4 Testimonial (Content Type ID: `testimonial`)
- **Customer Name** (Text) - Required
- **Company** (Text)
- **Position** (Text)
- **Content** (Long text) - Required
- **Rating** (Number - integer, 1-5)
- **Avatar** (Media - single file)
- **Is Active** (Boolean)
- **Order** (Number - integer)

#### 4.5 Project (Content Type ID: `project`)
- **Name** (Text) - Required
- **Slug** (Text) - Required, unique
- **Description** (Text)
- **Client** (Text)
- **Location** (Text)
- **Completion Date** (Date)
- **Category** (Text)
- **Images** (Media - multiple files)
- **Details** (Rich text)
- **Is Active** (Boolean)
- **Order** (Number - integer)

### Step 5: Switch to CMS Version
Once your content is set up, replace the current homepage:
```bash
# Backup current homepage
mv src/app/page.tsx src/app/page-static.tsx

# Activate CMS version
mv src/app/page-cms.tsx src/app/page.tsx
```

## Content Management Workflows

### Adding New Products
1. Login to Contentful
2. Go to **Content > Add Entry > Product**
3. Fill in all required fields:
   - Name: Display name of the product
   - Slug: URL-friendly version (e.g., "security-cabin")
   - Category: Product category
   - Short Description: Brief overview for listings
   - Full Description: Detailed rich text content
   - Features: List key features (one per line)
   - Applications: List use cases
   - Images: Upload high-quality product images
   - Is Active: Set to true to show on website
   - Order: Number for sorting (lower numbers appear first)
4. Click **Publish** to make it live

### Managing Company Information
1. Go to **Content > Company Info** (should have only one entry)
2. Update any company details, contact information, or images
3. Click **Publish** to update the website

### Adding Testimonials
1. Go to **Content > Add Entry > Testimonial**
2. Fill in customer details and testimonial content
3. Rate 1-5 stars
4. Upload customer photo if available
5. Set **Is Active** to true and choose **Order** for positioning
6. **Publish** to display on website

### Image Management Best Practices
- **Upload high-resolution images** (Contentful automatically optimizes)
- **Use descriptive filenames** for better SEO
- **Product images**: Minimum 800x600px, preferably 1200x800px
- **Hero images**: Minimum 1920x1080px for best quality
- **Supported formats**: JPG, PNG, WebP, GIF

## Technical Features

### Automatic Optimizations
- **Image optimization**: Automatic WebP conversion and resizing
- **SEO optimization**: Structured data and meta tags
- **Performance**: Lazy loading and caching
- **Mobile responsive**: All content adapts to screen sizes

### Fallback System
The website includes fallback data, so it works even if:
- CMS is temporarily unavailable
- Content is not yet configured
- Network issues occur

### Development vs Production
- **Development**: Uses fallback data if CMS not configured
- **Production**: Fetches live content from Contentful
- **Preview mode**: Can show unpublished content for review

## Content Publishing Workflow

### Draft → Review → Publish
1. **Create/Edit**: Make changes in Contentful (saves as draft)
2. **Preview**: Use preview mode to see changes before publishing
3. **Review**: Team members can review content
4. **Publish**: Make changes live on the website
5. **Monitor**: Check website to ensure updates appear correctly

### Content Scheduling
- Set **publish date** for future content
- **Unpublish** outdated content
- **Archive** old projects or testimonials

## Troubleshooting

### Content Not Appearing
1. Check if content is **Published** (not just saved)
2. Verify **Is Active** is set to true
3. Check environment variables are correct
4. Clear browser cache and refresh

### Images Not Loading
1. Ensure images are uploaded and published in Contentful
2. Check image file formats are supported
3. Verify image URLs in developer tools

### API Errors
1. Check CONTENTFUL_SPACE_ID and CONTENTFUL_ACCESS_TOKEN
2. Verify API key has correct permissions
3. Check Contentful service status

## Support and Maintenance

### Regular Tasks
- **Update product information** as inventory changes
- **Add new projects** to showcase portfolio
- **Collect and add testimonials** from satisfied customers
- **Update company information** as needed
- **Monitor and optimize images** for best performance

### Content Strategy
- **SEO**: Use relevant keywords in product descriptions
- **Visual appeal**: High-quality, professional images
- **User experience**: Clear, concise product information
- **Regular updates**: Keep content fresh and current

### Advanced Features (Future)
- **Multi-language support**: Arabic and English content
- **Product categories**: Organized product browsing
- **Blog/News section**: Company updates and industry news
- **Search functionality**: Content search across the website
- **Analytics integration**: Track content performance

## Getting Help
- **Contentful Documentation**: [contentful.com/developers/docs](https://www.contentful.com/developers/docs)
- **Video Tutorials**: Available in Contentful's help center
- **Support**: Contact your web developer for technical issues
- **Training**: Schedule team training sessions for content management

This CMS setup provides a professional, scalable solution for managing your SAAM Cabins website content without technical expertise required!